using System;
using Server;
using Server.Network;
using Server.Prompts;
using Server.Targeting;

namespace Server.Items
{
    public class SilverWovenTShirt : LevelShirt
	{
		private int m_Bonus = 0;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus { get { return m_Bonus; } set { m_Bonus = value; InvalidateProperties(); } }
      
      public override int ArtifactRarity{ get{ return 75; } }

		[Constructable]
		public SilverWovenTShirt()
		{
			Name = "Silver Woven T-Shirt";
         Hue = 1182;
			Weight = 2.0;

			Resistances.Energy = 15;
			Attributes.ReflectPhysical = 15;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Paralyze protection charges: " + ( m_Bonus / 20 ).ToString() + "<basefont color=White>" );
		}
		
		public override void OnDoubleClick( Mobile from )
		{
         if (!IsChildOf(from.Backpack))
         {
            from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
            return;
         }

			from.SendMessage( "Zamer stribrne mince (1 nabiti = 20 minci)" );
			from.Target = new InternalTarget( this );
		}

		public SilverWovenTShirt( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
			writer.Write((int)m_Bonus);
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
				{
					m_Bonus = reader.ReadInt();
					break;
				}
			}
		}
		
		private class InternalTarget : Target
		{
			private SilverWovenTShirt m_Item;

			public InternalTarget( SilverWovenTShirt levitem ) : base( 1, false, TargetFlags.None )
			{
            m_Item = levitem;
			}

			protected override void OnTarget( Mobile from, object target )
			{
			   if ( from == null || m_Item == null || m_Item.Deleted || target is StaticTarget || target is LandTarget )
			      return;
            
            if ( !( target is Tokens ) )
				{
					from.SendMessage( "Musis zamerit stribrne mince!" );
					return;
				}
				
				Item tokens = (Item) target;
					
				if ( tokens == null )
					from.SendMessage( "Neocekavana chyba (ERROR 01)!" );
				else if( !tokens.IsChildOf( from.Backpack ) )
					from.SendMessage( "Musis mit mince u sebe" );
				else
				{
					int need = ( tokens.Amount > 200 ) ? 200 : tokens.Amount;
					
               m_Item.Bonus += need;
               tokens.Consume( need );
               from.PlaySound( 501 );
               from.FixedParticles( 14120, 1, 10, 0x1F78, tokens.Hue, 5, EffectLayer.Waist );
					from.SendMessage("Triko absorbovalo {0} minci.", need );
				}
			}
		}
	}
}